/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.human.dto.MKihonDto;

import jp.mosp.kintai.vo.AttendanceListVo;
import jp.mosp.kintai.vo.AttendanceMenuVo;

import jp.mosp.system.dto.MYakusyokuDto;

public class AttendanceListAction extends AttendanceTotalAction {

	// R}h
	public	static final String CMD_ATTENDANCE_LIST_SHOW		= "K1010";
	private static final String CMD_ATTENDANCE_LIST_SELECT	= "K1011";
	private static final String CMD_ATTENDANCE_LIST_SEARCH	= "K1012";
	public  static final String CMD_ATTENDANCE_LIST_RE_SEARCH	= "K1013";
	public  static final String CMD_ATTENDANCE_CARD_SELECT  	= "K1014";

	/**
	 * RXgN^
	 */
	public AttendanceListAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		AttendanceListVo vo;
		vo = (AttendanceListVo)getStoredVo(CommonConst.VO_ATTENDANCE_LIST);
		if (vo == null) {
			vo = new AttendanceListVo();
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(CommonConst.VO_ATTENDANCE_LIST, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DBRlNV擾
		getConnection();
		// [U[擾
		getInfo(user.getUserId());
		// \
		Date current = util.getSystemDate();
		// ΑӊǗR}h
		if (getStoredVo(CommonConst.VO_EMPLOYEE_ATTENDANCE_LIST) != null) {
			// ԑJڊmF
			vo.setCmdMenuButton(vo.CMD_MENU_MAMAGE);
			vo.setCmdListButton(EmployeeAttendanceListAction.CMD_EMPLOYEE_LIST_RE_SEARCH);
			vo.setNamListButton(CommonConst.TTL_EMPLOYEE_SELECT);
		} else {
			vo.setCmdMenuButton(vo.CMD_MENU_INPUT);
			vo.setCmdListButton(vo.CMD_MENU_INPUT);
			vo.setNamListButton(CommonConst.NAM_MENU);			
		}
		// v_E擾
		vo.aryPltYear  = util.getYearArray(MospUtility.getYear (current), 2, 1);
		vo.aryPltMonth = util.getMonthArray();
		// ΑӏF@\mF
		if (isAttendanceApprovalFunction()) {
			vo.setMode(AttendanceListVo.MODE_POSSIBLE);
		} else {
			vo.setMode(AttendanceListVo.MODE_IMPOSSIBLE);
		}
		// R}h̏
		if (cmd.equals(CMD_ATTENDANCE_LIST_SHOW)) {
			// \
			// ΏێЈݒ
			vo.setSelectKCode(mKihon.getKCode());
			// Ώ۔Nݒ
			vo.setPltYear(String.valueOf(MospUtility.getYear(current)));
			vo.setPltMonth(String.valueOf(MospUtility.getMonth(current)));
			/*						
			 *  	2009/01/20	m.yoshida	ߓΉ
			 */
			vo.setHidDay(String.valueOf(MospUtility.getDay(current)));
			// 
			searchAttendanceList(vo);
		} else if (cmd.equals(CMD_ATTENDANCE_LIST_SELECT)) {
			// I
			// ΏێЈݒ
			vo.setSelectKCode(key1);
			// Ώ۔Nݒ
			vo.setPltYear(String.valueOf(MospUtility.getYear(current)));
			vo.setPltMonth(String.valueOf(MospUtility.getMonth(current)));
			/*						
			 *  	2009/01/20	m.yoshida	ߓΉ
			 */
			vo.setHidDay(String.valueOf(MospUtility.getDay(current)));
			// 
			searchAttendanceList(vo);
		} else if (cmd.equals(CMD_ATTENDANCE_LIST_SEARCH)) {
			// Ώ۔Nݒ
			vo.setParams(request);
			// 
			searchAttendanceList(vo);
		} else if (cmd.equals(CMD_ATTENDANCE_LIST_RE_SEARCH)) {
			// Č
			session.removeAttribute(MospConst.ATT_DTO);
			AttendanceMenuVo menuVo = (AttendanceMenuVo)getStoredVo(CommonConst.VO_ATTENDANCE_MENU);
			// ΏێЈݒ
			vo.setSelectKCode(menuVo.getHidKCode());
			// Ώ۔Nݒ
			vo.setPltYear(menuVo.getHidYear());
			vo.setPltMonth(menuVo.getHidMonth());
			/*						
			 *  	2009/01/20	m.yoshida	ߓΉ
			 */
			vo.setHidDay(menuVo.getHidDay());
			// 
			searchAttendanceList(vo);
		} else if (cmd.equals(CMD_ATTENDANCE_CARD_SELECT)) {
			// Ώ۔Nݒ
			vo.setParams(request);
			// 
			searchAttendance();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * Αӈꗗ
	 * @param vo AttendanceListVoCX^X
	 * @throws Exception
	 */
	private void searchAttendanceList(
			AttendanceListVo vo
	) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		// ΏۊԐݒ
		Date targetMonth;
		if (vo.getHidDay().length() != 0) {
			targetMonth = util.getDate(vo.getPltYear(), vo.getPltMonth(), vo.getHidDay());
		} else {
			targetMonth = util.getYearMonth(vo.getPltYear(), vo.getPltMonth());
		}
		// ΑӃf[^擾
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		getAttendanceListForView(vo.getSelectKCode(), targetMonth);
		// Wvf[^Ԑݒ
		setHours();
		// Wvf[^z쐬
		makeAttendanceArray();
		// Wv
		totalAttendanceDaily();
		// l{̎擾
		MKihonDto mKihonDto = getBasisInfo(vo.getSelectKCode());
		// I̐ݒ
		vo.setSelectKName(mKihonDto.getSimei());
		vo.setSelectSectionName(util.getCodeName(mKihonDto.getSCode(), getSectionArrayAll()));
		// FΎ蓖ݒ
		// E擾
		MYakusyokuDto positionDto = getHoldingPositionInfo(vo.getSelectKCode());
		if (chkExistDto(positionDto)) {
			// FΎ蓖̏ꍇA󗓂ɂ
			if (positionDto.getKaikin().equals(CommonConst.NAM_COMMON_FLAG_OFF)) {
				aryAttendanceCompile[17][1] = "";
			}
		}
		// Wvf[^ƃx𕪗
		String[] aryLabel 	= new String[aryAttendanceCompile.length];
		String[] aryCompile = new String[aryAttendanceCompile.length];
		for (int i = 0; i < aryAttendanceCompile.length; i++) {
			aryLabel[i] = aryAttendanceCompile[i][0];
			aryCompile[i] = aryAttendanceCompile[i][1];
		}
		// VOݒ
		vo.setFields(aryAttendance, aryCompile, aryLabel);
	}

}
